"""add watcher_messages table

Revision ID: ee545b0518c2
Revises: b62d21842ab7
Create Date: 2019-02-19 16:54:08.039085

"""

# revision identifiers, used by Alembic.
revision = 'ee545b0518c2'
down_revision = 'b62d21842ab7'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
  op.create_table('watcher_messages',
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.Column('updated_at', sa.DateTime(), nullable=False),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('message_type', sa.String(), nullable=False),
    sa.Column('message', sa.String(), nullable=False),
    sa.Column('available_until', sa.DateTime(), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
  )
  op.create_index('ix_watcher_messages_created_at', 'watcher_messages', ['created_at'], unique=False)


def downgrade():
  op.drop_index('ix_watcher_messages_created_at', table_name='watcher_messages')
  op.drop_table('watcher_messages')
