"""initial_data

Revision ID: initial_data
Revises: initial
Create Date: 2019-10-31 19:06:22.542122

"""

# revision identifiers, used by Alembic.
revision = 'initial_data'
down_revision = 'initial'

import uuid
from alembic import op
import sqlalchemy as sa


def upgrade():
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)

  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  config_table = meta.tables['config']

  session.execute(
    config_table.insert().values([
      {'grp': 'api', 'name': 'key', 'value': uuid.uuid4()},
      {'grp': 'global', 'name': 'dvr_path', 'value': ''},
      {'grp': 'global', 'name': 'homepage', 'value': 'map'},
      {'grp': 'global', 'name': 'homepage_guest', 'value': 'login'},
      {'grp': 'global', 'name': 'anonymous_access', 'value': '0'},
      {'grp': 'map', 'name': 'language', 'value': 'en'},
      {'grp': 'map', 'name': 'zoom', 'value': '10'},
      {'grp': 'map', 'name': 'center', 'value': '55.7512 37.6184'},
      {'grp': 'map', 'name': 'show_in_nav', 'value': '1'}
    ])
  )
  session.commit()


def downgrade():
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)  
  config_table = meta.tables['config']
  session.execute(
    config_table.delete()
  )
  session.commit()


