"""initial_migration

Revision ID: dde9e9569b4a
Revises: None
Create Date: 2019-10-29 16:30:11.169064

"""

# revision identifiers, used by Alembic.
revision = 'initial'
down_revision = None

from alembic import op
import sqlalchemy as sa

def upgrade():
  JSONType = sa.dialects.postgresql.JSON

  op.create_table('config',
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('grp', sa.Text(), nullable=False),
  sa.Column('name', sa.Text(), nullable=False),
  sa.Column('value', sa.Text(), nullable=True),
  sa.PrimaryKeyConstraint('id'),
  sqlite_autoincrement=True
  )
  op.create_index('config_key', 'config', ['grp', 'name'], unique=True)
  op.create_table('deleted_streams',
  sa.Column('registered_at', sa.Integer(), nullable=True),
  sa.Column('motion_detector_enabled', sa.Boolean(), nullable=False, server_default=sa.false()),
  sa.Column('motion_detector_notify', sa.String(), nullable=True),
  sa.Column('motion_detector_tags', sa.String(), nullable=True),
  sa.Column('vision_enabled', sa.Boolean(), nullable=True),
  sa.Column('vision_gpu', sa.Integer(), nullable=True),
  sa.Column('vision_areas', sa.String(), nullable=True),
  sa.Column('name', sa.Text(), nullable=False),
  sa.Column('title', sa.Text(), nullable=True),
  sa.Column('stream_url', sa.Text(), nullable=True),
  sa.Column('substream_url', sa.Text(), nullable=True),
  sa.Column('coordinates', sa.Text(), nullable=True),
  sa.Column('postal_address', sa.Text(), nullable=True),
  sa.Column('comment', sa.Text(), nullable=True),
  sa.Column('owner', sa.Text(), nullable=True),
  sa.Column('dvr_depth', sa.Integer(), nullable=True),
  sa.Column('dvr_space', sa.Integer(), nullable=True),
  sa.Column('dvr_path', sa.Text(), nullable=True),
  sa.Column('thumbnails', sa.Boolean(), nullable=True),
  sa.Column('onvif_thumbnail_url', sa.Text(), nullable=True),
  sa.Column('can_ptz', sa.Boolean(), nullable=True),
  sa.Column('onvif_url', sa.Text(), nullable=True),
  sa.Column('onvif_profile', sa.Text(), nullable=True),
  sa.Column('enabled', sa.Boolean(), nullable=True),
  sa.Column('static', sa.Boolean(), nullable=True),
  sa.Column('dvr_protected', sa.Boolean(), nullable=True),
  sa.Column('auth_token', sa.Text(), nullable=True),
  sa.Column('access', sa.String(length=20), nullable=True),
  sa.Column('server', sa.Text(), nullable=True),
  sa.Column('agent_id', sa.String(), nullable=True),
  sa.Column('agent_pin', sa.String(), nullable=True),
  sa.Column('agent_key', sa.String(), nullable=True),
  sa.Column('agent_model', sa.String(), nullable=True),
  sa.Column('agent_serial', sa.String(), nullable=True),
  sa.Column('external_id', sa.String(), nullable=True),
  sa.PrimaryKeyConstraint('name')
  )
  op.create_table('disk_usages',
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('camera_name', sa.String(), nullable=False),
  sa.Column('server', sa.String(), nullable=True),
  sa.Column('date', sa.Date(), nullable=False),
  sa.Column('disk_size_min', sa.BigInteger(), nullable=False),
  sa.Column('disk_size_max', sa.BigInteger(), nullable=False),
  sa.Column('event_count', sa.Integer(), nullable=False),
  sa.PrimaryKeyConstraint('id')
  )
  op.create_index(op.f('ix_disk_usages_camera_name'), 'disk_usages', ['camera_name'], unique=False)
  op.create_index(op.f('ix_disk_usages_date'), 'disk_usages', ['date'], unique=False)
  op.create_table('events',
  sa.Column('id', sa.String(length=36), nullable=False),
  sa.Column('type', sa.String(), nullable=True),
  sa.Column('camera_id', sa.String(), nullable=True),
  sa.Column('source', sa.String(), nullable=True),
  sa.Column('source_id', sa.String(), nullable=True),
  sa.Column('start_at', sa.Integer(), nullable=True),
  sa.Column('end_at', sa.Integer(), nullable=True),
  sa.Column('object_class', sa.String(), nullable=True),
  sa.Column('object_id', sa.String(), nullable=True),
  sa.Column('object_action', sa.String(), nullable=True),
  sa.Column('event_data', JSONType(), nullable=True),
  sa.Column('ext_data', JSONType(), nullable=True),
  sa.PrimaryKeyConstraint('id')
  )
  op.create_index('ix_events_start_at', 'events', ['start_at'], unique=False)
  op.create_index('ix_events_type', 'events', ['type'], unique=False)
  op.create_index('ix_events_type_camera_id', 'events', ['type', 'camera_id'], unique=False)
  op.create_index('ix_events_type_object_class', 'events', ['type', 'object_class'], unique=False)
  op.create_table('log_entries',
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('user', sa.String(), nullable=True),
  sa.Column('created_at', sa.Integer(), nullable=True),
  sa.Column('action_type', sa.String(), nullable=True),
  sa.Column('object_id', sa.String(), nullable=True),
  sa.Column('object_repr', sa.String(), nullable=True),
  sa.Column('object_type', sa.String(), nullable=True),
  sa.Column('event_data', JSONType(), nullable=True),
  sa.Column('request_data', JSONType(), nullable=True),
  sa.PrimaryKeyConstraint('id')
  )
  op.create_index('ix_log_entries_action_type', 'log_entries', ['action_type'], unique=False)
  op.create_index('ix_log_entries_created_at', 'log_entries', ['created_at'], unique=False)
  op.create_index('ix_log_entries_object_type', 'log_entries', ['object_type'], unique=False)
  op.create_index('ix_log_entries_user', 'log_entries', ['user'], unique=False)
  op.create_table('mosaics',
  sa.Column('created_at', sa.DateTime(), nullable=False),
  sa.Column('updated_at', sa.DateTime(), nullable=False),
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('visible', sa.Boolean(), nullable=False),
  sa.Column('title', sa.String(), nullable=False),
  sa.Column('type', sa.String(), nullable=False),
  sa.Column('cameras', sa.String(), nullable=False),
  sa.PrimaryKeyConstraint('id'),
  sqlite_autoincrement=True
  )
  op.create_table('motion_events',
  sa.Column('source', sa.Text(), nullable=False),
  sa.Column('block_utc', sa.Integer(), nullable=False),
  sa.Column('block_interval', sa.Integer(), nullable=False),
  sa.Column('block_data', sa.BigInteger(), nullable=True),
  sa.PrimaryKeyConstraint('source', 'block_utc', 'block_interval')
  )
  op.create_table('session_usages',
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('session_id', sa.String(length=40), nullable=False),
  sa.Column('user_name', sa.String(), nullable=False),
  sa.Column('ip', sa.String(), nullable=True),
  sa.Column('referer', sa.String(), nullable=True),
  sa.Column('type', sa.String(), nullable=True),
  sa.Column('created_at', sa.Integer(), nullable=False),
  sa.Column('updated_at', sa.Integer(), nullable=True),
  sa.Column('bytes', sa.BigInteger(), nullable=False, server_default="0"),
  sa.Column('duration', sa.BigInteger(), nullable=False, server_default="0"),
  sa.Column('dvr_request_from', sa.BigInteger(), nullable=False),
  sa.Column('dvr_request_duration', sa.BigInteger(), nullable=False, server_default="0"),
  sa.Column('event_count', sa.Integer(), nullable=False, server_default="0"),
  sa.PrimaryKeyConstraint('id')
  )
  op.create_index(op.f('ix_session_usages_session_id'), 'session_usages', ['session_id'], unique=True)
  op.create_index(op.f('ix_session_usages_user_name'), 'session_usages', ['user_name'], unique=False)
  op.create_table('stored_files',
  sa.Column('path', sa.Text(), nullable=False),
  sa.Column('b64_content', sa.Text(), nullable=False),
  sa.Column('mime_type', sa.String(), nullable=False),
  sa.Column('etag', sa.String(), nullable=True),
  sa.PrimaryKeyConstraint('path')
  )
  op.create_table('stream_usages',
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('source_id', sa.String(length=40), nullable=False),
  sa.Column('camera_name', sa.String(), nullable=False),
  sa.Column('server', sa.String(), nullable=True),
  sa.Column('connected_at', sa.Integer(), nullable=False),
  sa.Column('event_at', sa.Integer(), nullable=False),
  sa.Column('bitrate', sa.Integer(), nullable=False, server_default="0"),
  sa.Column('bytes', sa.BigInteger(), nullable=False, server_default="0"),
  sa.Column('duration', sa.BigInteger(), nullable=False, server_default="0"),
  sa.Column('event_count', sa.Integer(), nullable=False, server_default="0"),
  sa.PrimaryKeyConstraint('id')
  )
  op.create_index(op.f('ix_stream_usages_camera_name'), 'stream_usages', ['camera_name'], unique=False)
  op.create_index(op.f('ix_stream_usages_connected_at'), 'stream_usages', ['connected_at'], unique=False)
  op.create_index(op.f('ix_stream_usages_event_at'), 'stream_usages', ['event_at'], unique=False)
  op.create_index(op.f('ix_stream_usages_source_id'), 'stream_usages', ['source_id'], unique=True)
  op.create_index('idx_connected_event', 'stream_usages', ['connected_at', 'event_at'], unique=False)
  op.create_table('streamers',
  sa.Column('created_at', sa.DateTime(), nullable=False),
  sa.Column('updated_at', sa.DateTime(), nullable=False),
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('host', sa.String(), nullable=False),
  sa.Column('port', sa.Integer(), nullable=True),
  sa.Column('auth', sa.String(), nullable=True),
  sa.Column('cluster_key', sa.String(), nullable=True),
  sa.Column('is_filling', sa.Boolean(), nullable=False),
  sa.Column('dvr_path', sa.String(), nullable=True),
  sa.Column('max_bitrate', sa.Integer(), nullable=True),
  sa.Column('is_backup', sa.Boolean(), nullable=True),
  sa.PrimaryKeyConstraint('id'),
  sqlite_autoincrement=True
  )
  op.create_index(op.f('ix_streamers_host'), 'streamers', ['host'], unique=True)
  op.create_table('user_serials',
  sa.Column('created_at', sa.DateTime(), nullable=False),
  sa.Column('updated_at', sa.DateTime(), nullable=False),
  sa.Column('serial', sa.String(), nullable=False),
  sa.Column('owner', sa.String(), nullable=True),
  sa.PrimaryKeyConstraint('serial')
  )
  op.create_table('users',
  sa.Column('created_at', sa.DateTime(), nullable=False),
  sa.Column('updated_at', sa.DateTime(), nullable=False),
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('external_id', sa.Text(), nullable=True),
  sa.Column('email', sa.String(length=150), nullable=False),
  sa.Column('password_hash', sa.String(length=100), nullable=True),
  sa.Column('password_token', sa.String(length=100), nullable=True),
  sa.Column('is_active', sa.Boolean(), nullable=False),
  sa.Column('is_admin', sa.Boolean(), nullable=False),
  sa.Column('note', sa.Text(), nullable=True),
  sa.Column('authorized_ip', sa.String(length=100), nullable=True),
  sa.Column('is_peeklio', sa.Boolean(), nullable=False, server_default=sa.sql.false()),
  sa.Column('dvr_allowed', sa.Boolean(), server_default=sa.sql.true(), nullable=False),
  sa.Column('notification_email', sa.String(length=150), nullable=True),
  sa.Column('apikey', sa.String(), nullable=True),
  sa.Column('max_cam_slots', sa.Integer(), nullable=True, server_default="0"),
  sa.Column('max_dvr_days', sa.Integer(), nullable=True, server_default="0"),
  sa.Column('max_dvr_space', sa.Integer(), nullable=True, server_default="0"),
  sa.PrimaryKeyConstraint('id'),
  sqlite_autoincrement=True
  )
  op.create_index(op.f('ix_users_apikey'), 'users', ['apikey'], unique=True)
  op.create_index(op.f('ix_users_authorized_ip'), 'users', ['authorized_ip'], unique=True)
  op.create_index(op.f('ix_users_email'), 'users', ['email'], unique=True)
  op.create_index(op.f('ix_users_external_id'), 'users', ['external_id'], unique=True)
  op.create_index(op.f('ix_users_password_hash'), 'users', ['password_hash'], unique=False)
  op.create_index(op.f('ix_users_password_token'), 'users', ['password_token'], unique=False)
  op.create_table('cloud_streams',
  sa.Column('agent_id', sa.String(), nullable=True),
  sa.Column('agent_pin', sa.String(), nullable=True),
  sa.Column('agent_key', sa.String(), nullable=True),
  sa.Column('agent_model', sa.String(), nullable=True),
  sa.Column('agent_serial', sa.String(), nullable=True),
  sa.Column('registered_at', sa.Integer(), nullable=True),
  sa.Column('auth_token', sa.Text(), nullable=True),
  sa.Column('access', sa.String(length=20), nullable=True),
  sa.Column('vision_enabled', sa.Boolean(), nullable=True),
  sa.Column('vision_gpu', sa.Integer(), nullable=True),
  sa.Column('vision_areas', sa.String(), nullable=True),
  sa.Column('name', sa.Text(), nullable=False),
  sa.Column('title', sa.Text(), nullable=True),
  sa.Column('stream_url', sa.Text(), nullable=True),
  sa.Column('substream_url', sa.Text(), nullable=True),
  sa.Column('coordinates', sa.Text(), nullable=True),
  sa.Column('postal_address', sa.Text(), nullable=True),
  sa.Column('comment', sa.Text(), nullable=True),
  sa.Column('owner', sa.Text(), nullable=True),
  sa.Column('dvr_path', sa.String(), nullable=True),
  sa.Column('dvr_depth', sa.Integer(), nullable=True),
  sa.Column('dvr_space', sa.Integer(), nullable=True),
  sa.Column('thumbnails', sa.Boolean(), nullable=False),
  sa.Column('onvif_thumbnail_url', sa.Text(), nullable=True),
  sa.Column('can_ptz', sa.Boolean(), nullable=False),
  sa.Column('onvif_url', sa.Text(), nullable=True),
  sa.Column('onvif_profile', sa.Text(), nullable=True),
  sa.Column('enabled', sa.Boolean(), nullable=True),
  sa.Column('static', sa.Boolean(), nullable=False),
  sa.Column('dvr_protected', sa.Boolean(), nullable=True),
  sa.Column('server', sa.Text(), nullable=True),
  sa.Column('bitrate', sa.Integer(), nullable=True),
  sa.Column('provision_required', sa.Boolean(), nullable=True),
  sa.Column('external_id', sa.String(), nullable=True),
  sa.ForeignKeyConstraint(['server'], ['streamers.host'], ondelete='SET NULL'),
  sa.PrimaryKeyConstraint('name')
  )
  op.create_index(op.f('ix_cloud_streams_agent_id'), 'cloud_streams', ['agent_id'], unique=True)
  op.create_table('device_tokens',
  sa.Column('created_at', sa.DateTime(), nullable=False),
  sa.Column('updated_at', sa.DateTime(), nullable=False),
  sa.Column('token', sa.Text(), nullable=False),
  sa.Column('device_platform', sa.Text(), nullable=True),
  sa.Column('device_model', sa.Text(), nullable=True),
  sa.Column('device_version', sa.Text(), nullable=True),
  sa.Column('user_id', sa.Integer(), nullable=False),
  sa.Column('last_confirm_at', sa.Integer(), nullable=True),
  sa.Column('events_sent', sa.Integer(), nullable=False),
  sa.Column('events_pending', sa.Integer(), nullable=False),
  sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
  sa.PrimaryKeyConstraint('token'),
  sqlite_autoincrement=True
  )
  op.create_table('event_subscriptions',
  sa.Column('created_at', sa.DateTime(), nullable=False),
  sa.Column('updated_at', sa.DateTime(), nullable=False),
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('event_type', sa.Text(), nullable=False),
  sa.Column('notification_type', sa.Text(), nullable=False),
  sa.Column('camera_id', sa.Text(), nullable=True),
  sa.Column('streamer_id', sa.Integer(), nullable=True),
  sa.Column('user_id', sa.Integer(), nullable=False),
  sa.ForeignKeyConstraint(['streamer_id'], ['streamers.id'], ),
  sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
  sa.PrimaryKeyConstraint('id'),
  sqlite_autoincrement=True
  )
  op.create_table('files',
  sa.Column('id', sa.String(length=32), nullable=False),
  sa.Column('user_id', sa.Integer(), nullable=False),
  sa.Column('title', sa.String(length=250), nullable=False),
  sa.Column('note', sa.Text(), nullable=True),
  sa.Column('coordinates', sa.Text(), nullable=True),
  sa.Column('postal_address', sa.Text(), nullable=True),
  sa.Column('source', sa.Text(), nullable=True),
  sa.Column('server', sa.Text(), nullable=True),
  sa.Column('created_at', sa.Integer(), nullable=False),
  sa.Column('start_utc', sa.Integer(), nullable=False),
  sa.Column('duration', sa.Integer(), nullable=False),
  sa.Column('size', sa.Integer(), nullable=True),
  sa.Column('is_saved', sa.Boolean(), nullable=False),
  sa.Column('path', sa.String(length=500), nullable=True),
  sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
  sa.PrimaryKeyConstraint('id')
  )
  op.create_table('groups',
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('streamer_id', sa.Integer(), nullable=True),
  sa.Column('title', sa.Text(), nullable=False),
  sa.Column('poster', sa.Text(), nullable=True),
  sa.Column('coordinates', sa.Text(), nullable=True),
  sa.Column('postal_address', sa.Text(), nullable=True),
  sa.Column('note', sa.Text(), nullable=True),
  sa.Column('max_cam_slots', sa.Integer(), nullable=True),
  sa.Column('max_dvr_days', sa.Integer(), nullable=True),
  sa.Column('max_dvr_space', sa.Integer(), nullable=True),
  sa.Column('max_user_slots', sa.Integer(), nullable=True),
  sa.ForeignKeyConstraint(['streamer_id'], ['streamers.id'], ondelete='SET NULL'),
  sa.PrimaryKeyConstraint('id'),
  sa.UniqueConstraint('title'),
  sqlite_autoincrement=True
  )
  op.create_table('user_cameras',
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('user_id', sa.Integer(), nullable=False),
  sa.Column('camera_id', sa.Text(), nullable=False),
  sa.Column('order_num', sa.Integer(), nullable=False),
  sa.Column('comment', sa.Text(), nullable=True),
  sa.Column('can_ptz', sa.Boolean(), nullable=True, server_default=sa.sql.true()),
  sa.Column('can_dvr', sa.Boolean(), nullable=True, server_default=sa.sql.true()),
  sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
  sa.PrimaryKeyConstraint('id'),
  sqlite_autoincrement=True
  )
  op.create_index('user_camera', 'user_cameras', ['user_id', 'camera_id'], unique=True)
  op.create_table('user_data',
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('user_id', sa.Integer(), nullable=False),
  sa.Column('target', sa.Text(), nullable=True),
  sa.Column('key', sa.String(length=20), nullable=False),
  sa.Column('value', sa.Text(), nullable=True),
  sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
  sa.PrimaryKeyConstraint('id'),
  sqlite_autoincrement=True
  )
  op.create_table('watcher_sessions',
  sa.Column('created_at', sa.DateTime(), nullable=False),
  sa.Column('updated_at', sa.DateTime(), nullable=False),
  sa.Column('session_id', sa.String(), nullable=False),
  sa.Column('available_until', sa.DateTime(), nullable=True),
  sa.Column('user_id', sa.Integer(), nullable=False),
  sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
  sa.PrimaryKeyConstraint('session_id')
  )
  op.create_index('ix_watcher_sessions_created_at', 'watcher_sessions', ['created_at'], unique=False)
  op.create_table('file_shares',
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('file_id', sa.String(length=32), nullable=False),
  sa.Column('user_id', sa.Integer(), nullable=True),
  sa.Column('group_id', sa.Integer(), nullable=True),
  sa.ForeignKeyConstraint(['file_id'], ['files.id'], ),
  sa.ForeignKeyConstraint(['group_id'], ['groups.id'], ),
  sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
  sa.PrimaryKeyConstraint('id'),
  sqlite_autoincrement=True
  )
  op.create_index('file_share_refs', 'file_shares', ['file_id', 'user_id', 'group_id'], unique=True)
  op.create_index('file_userdata_refs', 'file_shares', ['file_id', 'user_id', 'group_id'], unique=True)
  op.create_table('file_userdata',
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('file_id', sa.String(length=32), nullable=False),
  sa.Column('user_id', sa.Integer(), nullable=False),
  sa.Column('is_seen', sa.Boolean(), nullable=False),
  sa.Column('is_pinned', sa.Boolean(), nullable=False),
  sa.Column('is_hidden', sa.Boolean(), nullable=False),
  sa.Column('note', sa.Text(), nullable=True),
  sa.ForeignKeyConstraint(['file_id'], ['files.id'], ),
  sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
  sa.PrimaryKeyConstraint('id'),
  sqlite_autoincrement=True
  )
  op.create_table('group_cameras',
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('group_id', sa.Integer(), nullable=False),
  sa.Column('camera_id', sa.Text(), nullable=False),
  sa.Column('order_num', sa.Integer(), nullable=False),
  sa.Column('comment', sa.Text(), nullable=True),
  sa.ForeignKeyConstraint(['group_id'], ['groups.id'], ),
  sa.PrimaryKeyConstraint('id'),
  sqlite_autoincrement=True
  )
  op.create_index('group_camera', 'group_cameras', ['group_id', 'camera_id'], unique=True)
  op.create_table('user_groups',
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('user_id', sa.Integer(), nullable=False),
  sa.Column('group_id', sa.Integer(), nullable=False),
  sa.Column('order_num', sa.Integer(), nullable=False),
  sa.Column('comment', sa.Text(), nullable=True),
  sa.Column('can_ptz', sa.Boolean(), nullable=True),
  sa.Column('can_dvr', sa.Boolean(), nullable=True),
  sa.Column('can_manage_users', sa.Boolean(), nullable=True),
  sa.Column('can_manage_cameras', sa.Boolean(), nullable=True),
  sa.ForeignKeyConstraint(['group_id'], ['groups.id'], ),
  sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
  sa.PrimaryKeyConstraint('id'),
  sqlite_autoincrement=True
  )
  op.create_index('user_group', 'user_groups', ['user_id', 'group_id'], unique=True)
  # ### end Alembic commands ###


def downgrade():
  # ### commands auto generated by Alembic - please adjust! ###
  op.drop_index('user_group', table_name='user_groups')
  op.drop_table('user_groups')
  op.drop_index('group_camera', table_name='group_cameras')
  op.drop_table('group_cameras')
  op.drop_table('file_userdata')
  op.drop_index('file_userdata_refs', table_name='file_shares')
  op.drop_index('file_share_refs', table_name='file_shares')
  op.drop_table('file_shares')
  op.drop_index('ix_watcher_sessions_created_at', table_name='watcher_sessions')
  op.drop_table('watcher_sessions')
  op.drop_table('user_data')
  op.drop_index('user_camera', table_name='user_cameras')
  op.drop_table('user_cameras')
  op.drop_table('groups')
  op.drop_table('files')
  op.drop_table('event_subscriptions')
  op.drop_table('device_tokens')
  op.drop_index(op.f('ix_cloud_streams_agent_id'), table_name='cloud_streams')
  op.drop_table('cloud_streams')
  op.drop_index(op.f('ix_users_password_token'), table_name='users')
  op.drop_index(op.f('ix_users_password_hash'), table_name='users')
  op.drop_index(op.f('ix_users_external_id'), table_name='users')
  op.drop_index(op.f('ix_users_email'), table_name='users')
  op.drop_index(op.f('ix_users_authorized_ip'), table_name='users')
  op.drop_index(op.f('ix_users_apikey'), table_name='users')
  op.drop_table('users')
  op.drop_table('user_serials')
  op.drop_index(op.f('ix_streamers_host'), table_name='streamers')
  op.drop_table('streamers')
  op.drop_index('idx_connected_event', table_name='stream_usages')
  op.drop_index(op.f('ix_stream_usages_source_id'), table_name='stream_usages')
  op.drop_index(op.f('ix_stream_usages_event_at'), table_name='stream_usages')
  op.drop_index(op.f('ix_stream_usages_connected_at'), table_name='stream_usages')
  op.drop_index(op.f('ix_stream_usages_camera_name'), table_name='stream_usages')
  op.drop_table('stream_usages')
  op.drop_table('stored_files')
  op.drop_index(op.f('ix_session_usages_user_name'), table_name='session_usages')
  op.drop_index(op.f('ix_session_usages_session_id'), table_name='session_usages')
  op.drop_table('session_usages')
  op.drop_table('motion_events')
  op.drop_table('mosaics')
  op.drop_index('ix_log_entries_user', table_name='log_entries')
  op.drop_index('ix_log_entries_object_type', table_name='log_entries')
  op.drop_index('ix_log_entries_created_at', table_name='log_entries')
  op.drop_index('ix_log_entries_action_type', table_name='log_entries')
  op.drop_table('log_entries')
  op.drop_index('ix_events_type_object_class', table_name='events')
  op.drop_index('ix_events_type_camera_id', table_name='events')
  op.drop_index('ix_events_type', table_name='events')
  op.drop_index('ix_events_start_at', table_name='events')
  op.drop_table('events')
  op.drop_index(op.f('ix_disk_usages_date'), table_name='disk_usages')
  op.drop_index(op.f('ix_disk_usages_camera_name'), table_name='disk_usages')
  op.drop_table('disk_usages')
  op.drop_table('deleted_streams')
  op.drop_index('config_key', table_name='config')
  op.drop_table('config')
  # ### end Alembic commands ###
