#!/bin/sh

# Elbrus gives:
# none ~ # uname -i
# PC-401
# none ~ # uname -m
# e2k
#
# Ubuntu 16.04
# root@demo:~# uname -i
# x86_64
# root@demo:~# uname -m
# x86_64
#
# Debian 9, 10, 11
# root@336207927bab:/# uname -i
# unknown
# root@336207927bab:/# uname -m
# x86_64


ARCH=`uname -m`
if [ "$ARCH" = "unknown" ]; then
  # Debian 9 gives unknown on this call
  ARCH=`uname -m`
fi
APP=`basename $0`

# Нужно именно $@ и в кавычках:
#
# b.sh 'My first' 'My second'
# With someApp "$*", 
# someApp would receive a single argument 'My first My second'. 
# With someApp "$@", someApp would receive two arguments, 'My first' and 'My second'.
#
# Без кавычек будет 4 аргумента: 'My', 'first', 'My', 'second'
#
exec "/opt/flussonic/lib/erlang/erts-12.0.4/bin/${ARCH}-linux-gnu/${APP}" "$@"

